% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program CaptureGraph.m
I = 65; J = 65;
M = 128*ones(I,J);
hf  =  figure;    % define a new figure  
image(M);         % create an image of M in the figure
clut = [(0:255)' (0:255)' (0:255)']/255;
colormap(clut);   % apply a grayscale clut to the figure

%define the coordinates in the image of M
set(gca,  'units',  'pixels',  'position',  ...
    [1 1 J-1 I-1],  'visible', 'off'); 
text('units',  'pixels',  'position',  [round(J/2 - 15) ...
    round(I/2)],  'color', [0.1 0.1 0.1],  'fontsize', ...
    30,  'string',  'A'); 
drawnow;             % Draw letter "A"
tim = getframe(gca); % Capture the image from the graph window
close(hf);
tim2  = tim.cdata(1:(I-1),  1:(J-1), :) % Extract the image of "A"
                                        % from cdata. 
showImage(tim2,   'grayscale');

